#include "stdafx.h"
#include "osutils.h"

string ChangeFileExtension(string OldFilename,string NewExtension)
{
    size_t DotPos;
    
    //change extension of the dff file
    DotPos=OldFilename.find_first_of('.', 0);
    if (DotPos!=string::npos)
        //found an extension, now replace it
        return OldFilename.substr(0,DotPos)+NewExtension;
    else
        //no extension found, so just add a new one
        return OldFilename+NewExtension;
}

string GetFilePath(string Filename)
{
//This function strips the directory part off of a Path+Filename and
//returns the directory. Actually, it just splits off anything after the
//last slash. The returned value has no trailing slash.
    size_t SlashPos;

    SlashPos=Filename.find_last_of('\\');
    if (SlashPos!=string::npos)
        //found a slash, so split the string there
        return Filename.substr(0,SlashPos);
    else
        //no extension found, so return the original string
        return Filename;
}

string GetParentDir(string Filename)
{
//Return the parent directory of Filename
//Strip off everything after the last slash, which is exactly
//what GetFilePath does (at the moment).
    return GetFilePath(Filename);
}

string GetFileVersion(const char *filename, WORD languageID )
{
    //Return the version information for the file
    string Result;
    char ThisFilename[256]; //,FileVersionText[256];
    DWORD VersionSize;
    unsigned int VersionBytes;
    LPVOID FileVersion;
    LPVOID pBuff; 
    
    GetModuleFileName(GetModuleHandle(filename),
        ThisFilename,sizeof(ThisFilename));
    VersionSize=GetFileVersionInfoSize(ThisFilename,0);
    if (VersionSize>0) {
        FileVersion=malloc(VersionSize);
        if (GetFileVersionInfo(ThisFilename,0,VersionSize,FileVersion))
        {
            //print language number to a string in hex
            char language[5];
            sprintf(language, "%4x", languageID);
            //replace spaces with 0s
            for (int i=0; i<4; i++)
            {
                if (language[i] == ' ')
                {
                    language[i] = '0';
                }
            }

            string nameandversion = string("\\StringFileInfo\\")
                + string(language) + string("04B0\\FileVersion");
            
            char cstrnameandversion[256];
            strcpy(cstrnameandversion, nameandversion.c_str());

            VersionBytes=VersionSize;
            if (VerQueryValue(FileVersion,
                //_TEXT("\\StringFileInfo\\040904B0\\FileVersion"),
                cstrnameandversion,
                &pBuff,&VersionBytes)&&VersionBytes)
            {
                Result.assign((char *)pBuff); //VersionBytes);
            }
        }
        free(FileVersion);
    }
    return Result;
}

string GetResourceString(int id)
{
	static TCHAR buf[256];
    HINSTANCE ResourceInstance=AfxGetResourceHandle();

	if (ResourceInstance)
		return LoadString(ResourceInstance, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
}
